﻿using System;
using System.IO;
using System.Linq;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Web.Configuration;
using System.Web.Services;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.ServiceModel.Activation;
using System.Web.Script.Serialization;
using VIRP;
using VIRP.AHOBPR.BLL;
using VIRP.AHOBPR.BO;

namespace VIRP_SERVICE
{
    [WebService(Namespace = "http://DNS")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [WebServiceBindingAttribute(Name = "AHOBPR", Namespace = "http://DNS")]
    [ServiceContract(Name = "AHOBPR", Namespace = "http://DNS")]
    [System.ComponentModel.ToolboxItem(false)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public partial class AHOBPR : System.Web.Services.WebService
    {
        #region soap

        //[WebMethod]
        //public bool AddEdipiForUpdate(string edipi)
        //{
        //    bool result = false;
        //    try
        //    {
        //        Regex regex = new Regex("^[0-9]{10}$");
        //        if (regex.IsMatch(edipi))
        //        {
        //            //var manager = new DataManager();
        //            //result = manager.AddEdipiToDatabase(edipi);
        //        }
        //    }
        //    catch
        //    {
        //        result = false;
        //    }
        //    return result;
        //}

        //[WebMethod]
        //public string UpdateRegistrantWithDoDInfo(string edipi)
        //{
        //    string result = string.Empty;
        //    try
        //    {
        //        //var manager = new AHOBPRRegistrantManager();
        //        //int registrantDbId = EdipiValidator.IsValid(edipi) ? manager.GetRegistrantId(edipi) : 0;
        //        //if (registrantDbId != 0)
        //        //{
        //        //    ComprehensiveUpdater updater = new ComprehensiveUpdater();
        //        //    result = updater.UpdateRegistrant(AHOBPRGlobal.RegistrantManagers, edipi, registrantDbId);
        //        //}
        //        //else
        //        //{
        //        result = "error: no registrant found";
        //        //}
        //    }
        //    catch (Exception ex)
        //    {
        //        result = $"{ex.Message}";
        //    }
        //    return result;
        //}

        #endregion

        #region rest_xml

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "bens/queue/add/{edipi}")]
        //public bool AddEdipiForUpdateXml(string edipi)
        //{
        //    return this.AddEdipiForUpdate(edipi);
        //}

        //[OperationContract]
        //[WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Xml, UriTemplate = "dodimport/update/{edipi}")]
        //public string UpdateRegistrantWithDoDInfoXml(string edipi)
        //{
        //    return this.UpdateRegistrantWithDoDInfo(edipi);
        //}

        #endregion

        #region rest_json

        //55 web methods - 35 complete

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "bens/queue/add/{edipi}")]
        public bool AddEdipiForUpdate(string edipi)
        {
            //throw new NotImplementedException();
            bool result = false;
            try
            {
                if (EdipiIsValid(edipi))
                {
                    UPDATES_BENS_NOTIFICATION bens = new UPDATES_BENS_NOTIFICATION();
                    bens.EDIPI = edipi;
                    bens.UPDATES_BENS_NOTIFICATION_ID = UPDATES_BENS_NOTIFICATIONManager.Save("RESTful Service", 0, bens);
                    result = true;

                    //var manager = new DataManager();
                    //result = manager.AddEdipiToDatabase(edipi);
                }
            }
            catch
            {
                result = false;
            }
            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "dodimport/update/{edipi}")]
        public string UpdateRegistrantWithDoDInfo(string edipi)
        {
            //throw new NotImplementedException();
            string result = string.Empty;
            try
            {
                if (EdipiIsValid(edipi))
                {
                    REGISTRANT registrant = REGISTRANTManager.GetItemByEdipi(edipi);
                    if (registrant != null)
                    {
                        //TLB.TODO
                        result = REGISTRANTManager.UpdateAll(edipi, registrant.REGISTRANT_ID);
                    }
                    else
                        result = "error: no registrant found";
                }
                else
                    result = "error: invalid EDIPI";

                //var manager = new AHOBPRRegistrantManager();
                //int registrantDbId = EdipiValidator.IsValid(edipi) ? manager.GetRegistrantId(edipi) : 0;
                //if (registrantDbId != 0)
                //{
                //    ComprehensiveUpdater updater = new ComprehensiveUpdater();
                //    result = updater.UpdateRegistrant(AHOBPRGlobal.RegistrantManagers, edipi, registrantDbId);
                //}
                //else
                //{
                //    result = "error: no registrant found";
                //}
            }
            catch (Exception ex)
            {
                result = $"{ex.Message}";
            }
            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "bens/update/all")]
        public string ProcessBensNotifications()
        {
            throw new NotImplementedException();
            //string result = string.Empty;
            //try
            //{
            //    BensUpdater updater = new BensUpdater();
            //    result = updater.ReconcileQueue(AHOBPRGlobal.RegistrantManagers);
            //}
            //catch (InvalidOperationException ex)
            //{
            //    result = $"{ex.Message}";
            //}
            //catch (Exception ex)
            //{
            //    result = $"error: {ex.Message}";
            //}
            //return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "jsonparserfollowup/{id}")]
        public bool JsonParserFollowup(string id)
        {
            //throw new NotImplementedException();
            bool result = false;

            if (string.IsNullOrEmpty(id))
            {
                result = true;
            }
            else
            {
                try
                {
                    AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
                    result = manager.ParseJsonFollowupData(Convert.ToInt32(id));
                }
                catch
                {
                    result = false;
                }
            }

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "jsonparser/{id}")]
        public bool JsonParser(string id)
        {
            //throw new NotImplementedException();
            bool result = false;

            if (string.IsNullOrEmpty(id))
            {
                result = true;
            }
            else
            {
                try
                {
                    AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
                    result = manager.ParseJsonData(Convert.ToInt32(id));
                }
                catch
                {
                    result = false;
                }
            }

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "appnotification")]
        public string AppNotification()
        {
            //throw new NotImplementedException();

            string notification = string.Empty;
            VIRP.CRS.BO.APPLICATION_STATUS appStatus = VIRP.CRS.BLL.APPLICATION_STATUSManager.GetApplicationStatus("AHOBPR");
            if (appStatus != null)
            {
                if (appStatus.PROCESS_FLAG == 1)
                {
                    notification = appStatus.MESSAGE;
                }
            }
            return notification;

            //AHOBPRGenericManager manager = new AHOBPRGenericManager();
            //return manager.GetApplicationNotification();
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatename2/{userid}/{lastname}/{firstname}/{createdby}")]
        public bool NameUpdate2(string userid, string lastname, string firstname, string createdby)
        {
            return this.NameUpdate(userid, lastname, firstname, string.Empty, createdby);
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatename/{userid}/{lastname}/{firstname}/{middlename}/{createdby}")]
        public bool NameUpdate(string userid, string lastname, string firstname, string middlename, string createdby)
        {
            //throw new NotImplementedException();
            bool results = false;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            REGISTRANT_JSON record = null;

            // Update User Json with new name
            record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                BprUser bprUser = serializer.Deserialize<BprUser>(record.JSON_DATA);
                bprUser.firstName = firstname;
                bprUser.lastName = lastname;
                bprUser.middleName = middlename;

                results = SaveBprUser(userid, serializer.Serialize(bprUser), createdby) != null;
            }

            // Update Info Json with new name
            record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeInfo);
            if (record != null)
            {
                BprInfo bprInfo = serializer.Deserialize<BprInfo>(record.JSON_DATA);
                if (bprInfo != null)
                {
                    bprInfo.edipiMismatched = false;
                    bprInfo.edipiVerifiedDate = string.Empty;
                    if (bprInfo.contactInfo != null)
                    {
                        bprInfo.contactInfo.firstName = firstname;
                        bprInfo.contactInfo.lastName = lastname;
                        bprInfo.contactInfo.middleName = middlename;
                    }
                    results = SaveBprInfo(userid, serializer.Serialize(bprInfo), createdby) != null;
                }
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "totalparticipants")]
        public string TotalParticipants()
        {
            //throw new NotImplementedException();
            return REGISTRANTManager.GetTotalParticipants();
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "version")]
        public string Version()
        {
            //throw new NotImplementedException();
            return VIRP.CRS.BLL.VIRPManager.GET_VERSION();
            //return BaseCode.WebSiteVersion.BuildVersion.ToString();
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "jsonparser/resetglobal")]
        public bool ResetGlobalVariables()
        {
            //TLB.TODO - determine if/how global variables will be used
            throw new NotImplementedException();
            //bool result = false;
            //AHOBPRFormResponseManager manager = new AHOBPRFormResponseManager();
            //result = manager.ResetGlobalVariables();
            //return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "download/{fileType}/{fileId}")]
        public byte[] GetFile(string fileType, string fileId)
        {
            //throw new NotImplementedException();
            return REGISTRANT_FILEManager.GetFile(fileId, fileType);
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "info/{id}")]
        public string BprInfo(string id)
        {
            //throw new NotImplementedException();
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeInfo);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "dodimport/{edipi}/{ssn}")]
        public string BprDoDImport(string edipi, string ssn)
        {
            //throw new NotImplementedException();
            BprDoDDeploymentImports imports = null;
            try
            {
                REGISTRANT registrant = REGISTRANTManager.GetRegistrantById(edipi, ssn);
                if (registrant != null)
                {
                    imports = BprDoDDeploymentImportsManager.GetBprDoDDeploymentImports(registrant);
                }
                ////Isn't there supposed to be a IOC container here?
                //IDeploymentImporter manager = CreateDoDImporter();
                //if (manager != null)
                //{
                //    imports = manager.GetDoDDeploymentImports(edipi, ssn);
                //}
            }
            catch (NullReferenceException ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //AHOBPRLogger.LogErrorMessage("Null Reference", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //AHOBPRLogger.LogErrorMessage("Exception", GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return (imports != null) ? new JavaScriptSerializer().Serialize(imports) : "{}";
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "user/{id}")]
        public string BprUser(string id)
        {
            //throw new NotImplementedException();
            string results = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "userid/{id}")]
        public string BprUserId(string id)
        {
            //throw new NotImplementedException();
            string userId = string.Empty;

            if (!string.IsNullOrEmpty(id))
            {
                userId = REGISTRANTManager.GetUserIdByRegistrantId(Convert.ToInt32(id));
            }

            return userId;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "pdfregistrantlist/{startdate}/{enddate}")]
        public List<string> PdfRegistrantList(string startdate, string enddate)
        {
            //throw new NotImplementedException();
            List<string> urserIds = null;

            if (!string.IsNullOrEmpty(startdate) && !string.IsNullOrEmpty(enddate))
            {
                if (startdate.Length == 8 && enddate.Length == 8)
                {
                    try
                    {
                        DateTime startDateTime = DateTime.MinValue;
                        DateTime endDateTime = DateTime.MinValue;

                        startDateTime = Convert.ToDateTime(startdate.Substring(4, 2) + "/" + startdate.Substring(6, 2) + "/" + startdate.Substring(0, 4));
                        endDateTime = Convert.ToDateTime(enddate.Substring(4, 2) + "/" + enddate.Substring(6, 2) + "/" + enddate.Substring(0, 4));

                        if (startDateTime != DateTime.MinValue && endDateTime != DateTime.MinValue)
                        {
                            urserIds = REGISTRANTManager.PdfRegistrantList(startDateTime, endDateTime);
                        }
                        else
                        {
                            throw new Exception("PDF Utility: Invalid start date (" + startdate + ") or end date (" + enddate + ").");
                        }
                    }
                    catch (Exception ex)
                    {
                        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "AHOBPR Restful Service", 0);
                    }
                }
            }

            return urserIds;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "pdfmetadata/{userid}")]
        public string PdfMetaData(string userid)
        {
            //throw new NotImplementedException();
            string result = string.Empty;

            result = REGISTRANTManager.GetPdfMetaData(userid);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "lastpdfrundate")]
        public string LastPdfRunDate()
        {
            //throw new NotImplementedException();
            string result = string.Empty;

            result = INTERFACE_CALL_LOGManager.GetLastPdfRunDate();

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "processqueuebatch/{queuebatchid}")]
        public bool ProcessQueueBatch(string queuebatchid)
        {
            //throw new NotImplementedException();
            return QUEUE_STATUSManager.ProcessQueueBatch(queuebatchid);
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "responses/{id}")]
        public string BprResponses(string id)
        {
            //throw new NotImplementedException();
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeResponses);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "reopenquestionnaire/{id}")]
        public bool ReopenQuestionnaire(string id)
        {
            //throw new NotImplementedException();
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            return manager.ReopenQuestionnaire(id);
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "form/{id=null}")]
        public string BprForm(string id)
        {
            //throw new NotImplementedException();
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            REGISTRANT_JSON record = manager.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeForm);
            if (record != null)
            {
                results = record.JSON_DATA;
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "formfollowup/{id=null}")]
        public string BprFormFollowup(string id)
        {
            //throw new NotImplementedException();
            string results = null;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            results = manager.GetJsonFollowup(id, AHOBPRGlobal.AhobprJsonTypeFormFollowup, id);

            return results;
        }

        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "defaultFormId/")]
        public string DefaultBprFormId()
        {
            //throw new NotImplementedException();
            return AHOBPRGlobal.AhobprDefaultFormId;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "deploymentlocations/{search=null}")]
        public string BprDeploymentLocations(string search)
        {
            //throw new NotImplementedException();
            string results = string.Empty;
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            BprDeploymentLocation[] locations = STD_DEPLOYMENT_LOCATIONManager.GetDeploymentLocations(search.Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " "));
            results = serializer.Serialize(locations);
            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "basenames/{search=null}")]
        public string BprBaseNames(string search)
        {
            //throw new NotImplementedException();
            string results = string.Empty;
            JavaScriptSerializer serializer = new JavaScriptSerializer();
            BprDeploymentBaseName[] bases = STD_DEPLOYMENT_LOCATIONManager.GetDeploymentBaseNames(search.Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " ").Replace("__", " "));
            results = serializer.Serialize(bases);

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "userfollowupforms/{id}")]
        public string BprUserFollowupForms(string id)
        {
            //throw new NotImplementedException();
            string results = null;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetJsonFollowups(id, AHOBPRGlobal.AhobprJsonTypeUserForm);
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprUserFollowupForm userForm = new BprUserFollowupForm();
                List<BprUserFollowupForm> userFormList = new List<BprUserFollowupForm>();
                foreach (string userFormJson in records)
                {
                    userForm = serializer.Deserialize<BprUserFollowupForm>(userFormJson);
                    userFormList.Add(userForm);
                }
                BprUserFollowupForms userForms = new BprUserFollowupForms();
                userForms._id = Guid.NewGuid().ToString();
                userForms.userFollowupForms = userFormList.ToArray();
                results = serializer.Serialize(userForms);
            }
            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "messages/{id}")]
        public string BprMessages(string id)
        {
            //throw new NotImplementedException();
            string results = null;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetJsonFollowups(id, AHOBPRGlobal.AhobprJsonTypeMessage);
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprMessage message = new BprMessage();
                List<BprMessage> messages = new List<BprMessage>();
                foreach (string jsonData in records)
                {
                    message = serializer.Deserialize<BprMessage>(jsonData);
                    message.body = message.body.Replace("\r\n", "<br />");
                    messages.Add(message);
                }
                BprMessages bprMessages = new BprMessages();
                bprMessages.userId = id;
                messages = (from m in messages
                            orderby Convert.ToInt32(m._id) descending
                            select m).ToList();
                bprMessages.messages = messages.ToArray();
                results = serializer.Serialize(bprMessages);
            }
            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "followupformresponses/{userid}/{formid}")]
        public string BprFollowUpFormResponse(string userid, string formid)
        {
            //throw new NotImplementedException();
            string result = string.Empty;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.GetJsonFollowup(userid, AHOBPRGlobal.AhobprJsonTypeResponsesFollowup, formid);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updateregistrantstatus/{userid}/{newstatus}/{createdby}")]
        public String UpdateRegistrantStatus(String userid, String newstatus, String createdby)
        {
            //throw new NotImplementedException();
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            JavaScriptSerializer serializer = new JavaScriptSerializer();

            // Update User Json with new status
            REGISTRANT_JSON record = manager.GetJsonData(userid, AHOBPRGlobal.AhobprJsonDataTypeUser);
            if (record != null)
            {
                BprUser bprUser = serializer.Deserialize<BprUser>(record.JSON_DATA);

                bprUser.userState = new BprUserState() { lastUpdated = DateTime.UtcNow.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"), state = newstatus };
                results = SaveBprUser(userid, serializer.Serialize(bprUser), createdby);
            }

            //Moved logic to SaveBprUser
            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatedefaultformid/{defaultformid}")]
        public String UpdateDefaultFormId(String defaultformid)
        {
            //throw new NotImplementedException();
            String results = String.Empty;

            try
            {
                System.Configuration.Configuration config = WebConfigurationManager.OpenWebConfiguration("~");
                //Not sure what the MyValue setting is for, doesn't seem to exist
                System.Configuration.KeyValueConfigurationElement setting = config.AppSettings.Settings["MyValue"];
                config.AppSettings.Settings["AhobprDefaultFormId"].Value = defaultformid;
                config.Save();
                results = "true";
            }
            catch //(Exception ex)
            {
                results = "false";
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "dbreset")]
        public bool ResetDatabase()
        {
            //throw new NotImplementedException();
            return REGISTRANTManager.ResetDatabase();
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "deleteregistrant/{registrantid}")]
        public bool DeleteRegistrant(string registrantid)
        {
            //throw new NotImplementedException();
            if (string.IsNullOrEmpty(registrantid) || registrantid.All(Char.IsDigit) == false)
            {
                return true;
            }
            else
            {
                int id = Convert.ToInt32(registrantid);
                return REGISTRANTManager.DeleteOneRegistrant(id);
            }
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "deletecprslog/{registrantid}")]
        public bool DeleteCprsLog(string registrantid)
        {
            //throw new NotImplementedException();
            if (string.IsNullOrEmpty(registrantid) || registrantid.All(Char.IsDigit) == false)
            {
                return true;
            }
            else
            {
                int id = Convert.ToInt32(registrantid);
                return CPRS_LOGManager.DeleteCprsLog(id);
            }
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "setmigrationmode/{newmode}")]
        public bool SetMigrationMode(String newmode)
        {
            //throw new NotImplementedException();
            if (newmode.ToLower() != "migration")
                PROCESS_METRICSManager.ClearProcessMetrics();

            //if (newmode.ToLower() == "migration")
            //{
            //    SetServiceMode("migration");

            //}
            //else
            //{
            //    //Clear the process metrics table:
            //    (new AHOBPRGenericManager()).ClearProcessMetrics();

            //    SetServiceMode("normal");
            //}

            System.Configuration.Configuration config = System.Web.Configuration.WebConfigurationManager.OpenWebConfiguration("~");
            System.Configuration.KeyValueConfigurationElement setting = config.AppSettings.Settings["MyValue"];
            config.AppSettings.Settings["ServiceMode"].Value = newmode;
            config.Save();

            return true;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "getdaspdf/{registrantid}")]
        public byte[] GetDasPdf(String registrantid)
        {
            //throw new NotImplementedException();
            byte[] value = new byte[0];

            try
            {
                value = INTERFACE_CALL_LOGManager.GetDasPdf(registrantid);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //AHOBPRLogger.LogErrorMessage("Exception: " + ex.Message, "AHOBPR.svc." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }

            return value;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "createfollowupformjson/{toolformid}/{issystemwide}/{createdby}")]
        public bool CreateFollowUpFormJson(string toolformid, string issystemwide, string createdby)
        {
            //throw new NotImplementedException();
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateFollowupFormJson(toolformid, issystemwide, createdby);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "UpdateFollowupFormJsonSystemWide/{toolformid}")]
        public bool UpdateFollowupFormJsonSystemWide(string toolformid)
        {
            //throw new NotImplementedException();
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.UpdateFollowupFormJsonSystemWide(toolformid);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "createmessagejson/{registrantId}/{emailtemplateid}/{createdby}")]
        public bool CreateMessageJson(string registrantId, string emailtemplateid, string createdby)
        {
            //throw new NotImplementedException();
            bool result = false;

            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateMessageJson(registrantId, emailtemplateid, createdby);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "createuserformjson/{registrantid}/{formid}/{createdby}")]
        public bool CreateUserFormJson(string registrantid, string formid, string createdby)
        {
            //throw new NotImplementedException();
            bool result = false;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            result = manager.CreateUserFormJson(registrantid, formid, createdby);

            return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "systemwideformjsons")]
        public string SystemWideFormJsons()
        {
            //throw new NotImplementedException();
            string results = string.Empty;
            AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            List<string> records = manager.GetSystemWideFormJsons();
            if (records.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprUserFollowupForm userForm = new BprUserFollowupForm();
                BprForm form = new BprForm();
                List<BprUserFollowupForm> userFormList = new List<BprUserFollowupForm>();
                foreach (string formJson in records)
                {
                    form = serializer.Deserialize<BprForm>(formJson);
                    userForm = new BprUserFollowupForm();
                    userForm._id = form._id;
                    userForm.name = form.name;
                    userForm.title = form.title;
                    userFormList.Add(userForm);
                }
                BprUserFollowupForms userForms = new BprUserFollowupForms();
                userForms._id = Guid.NewGuid().ToString();
                userForms.userFollowupForms = userFormList.ToArray();
                results = serializer.Serialize(userForms);
            }

            return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "scriptsbatch")]
        public string ScriptsBatch()
        {
            throw new NotImplementedException();
            //AHOBPRScriptsManager manager = new AHOBPRScriptsManager();
            //string results = manager.GetScriptsBatch();
            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatescriptsbatchstatus/{id}/{type}")]
        public bool UpdateScriptsBatchStatus(string id, string type)
        {
            throw new NotImplementedException();
            //bool result = false;
            //AHOBPRScriptsManager manager = new AHOBPRScriptsManager();
            //result = manager.UpdateScriptsBatchStatus(id, type);
            //return result;
        }

        [OperationContract]
        [WebInvoke(Method = "GET",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "userrole/{username}")]
        public string UserRole(string username)
        {
            throw new NotImplementedException();
            //string role = string.Empty;
            //AHOBPRGenericManager manager = new AHOBPRGenericManager();
            //role = manager.GetUserRole(username);
            //return role;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "info/{userId}")]
        public string SaveBprInfo(string userId, string bprInfo)
        {
            throw new NotImplementedException();
            //return this.SaveBprInfo(userId, bprInfo, string.Empty);
        }

        /// <summary>
        /// Save Bpr Info
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="bprInfo"></param>
        /// <param name="createdBy"></param>
        /// <returns></returns>
        string SaveBprInfo(string userId, string bprInfo, string createdBy)
        {
            throw new NotImplementedException();
            //string results = string.Empty;

            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeInfo, bprInfo, createdBy);
            //if (registrantJson != null)
            //{
            //    try
            //    {
            //        results = registrantJson.JSON_DATA;
            //    }
            //    catch
            //    {
            //        results = string.Empty;
            //    }
            //}

            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "user/{userId}")]
        public string SaveBprUser(string userId, string bprUser)
        {
            throw new NotImplementedException();
            //return this.SaveBprUser(userId, bprUser, string.Empty);
        }

        /// <summary>
        /// Save Bpr User
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="bprUser"></param>
        /// <param name="createdBy"></param>
        /// <returns></returns>
        string SaveBprUser(string userId, string bprUser, string createdBy)
        {
            throw new NotImplementedException();
            //string results = string.Empty;
            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //JavaScriptSerializer serializer = new JavaScriptSerializer();
            //REGISTRANT_JSON record = null;
            //string oldStatus = string.Empty;
            //string newStatus = string.Empty;

            //// Get latest user record
            //record = manager.GetJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeUser);
            //if (record != null)
            //{
            //    BprUser oldUser = serializer.Deserialize<BprUser>(record.JSON_DATA);
            //    if (oldUser != null) oldStatus = oldUser.userState.state;

            //    BprUser newUser = serializer.Deserialize<BprUser>(bprUser);
            //    if (newUser != null) newStatus = newUser.userState.state;

            //    //There is a defect where old MongoDB session data is overwriting SQL Server data
            //    //Do not allow status updates if it regresses the user back to a lower status
            //    if ((oldStatus == "PARTICIPANT" || oldStatus == "ELIGIBLE" || oldStatus == "REVIEWED_ELIGIBLE" || oldStatus == "REVIEWED_NOT_ELIGIBLE")
            //        && (newStatus == "NOT_ELIGIBLE" || newStatus == "REVIEW" || newStatus == "CONSENT" || newStatus == "NOT_CONSENT" || newStatus == "REVIEW_REQUESTED"))
            //    {
            //        newStatus = oldStatus;
            //    }
            //    else if ((oldStatus == "ELIGIBLE")
            //        && (newStatus == "REVIEWED_NOT_ELIGIBLE" || newStatus == "REVIEWED_ELIGIBLE"))
            //    {
            //        newStatus = oldStatus;
            //    }

            //    newUser.userState = new BprUserState() { lastUpdated = DateTime.UtcNow.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"), state = newStatus };

            //    bprUser = serializer.Serialize(newUser);
            //}

            //REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeUser, bprUser, createdBy);
            //if (registrantJson != null)
            //{
            //    results = registrantJson.JSON_DATA;

            //    try
            //    {
            //        //Update Registrant Table
            //        manager.ParseUserJson(results);
            //    }
            //    catch
            //    {
            //        results = string.Empty;
            //    }
            //}

            ////Business Rule: Registrant can correct errors within 30 days
            ////Below will clear out completed dates and pdf files
            //if (oldStatus == "PARTICIPANT" && newStatus != "PARTICIPANT")
            //{
            //    // Update the response json if it has questionnaire completed date
            //    record = manager.GetJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeResponses);
            //    if (record != null && !string.IsNullOrEmpty(record.JSON_DATA))
            //    {
            //        //There is response JSON data in the database with an array type for "answerValue"
            //        //however the plural "answerValues" is supposed to be used for an array answer
            //        string search = "answerValue" + '"' + ":[";
            //        string replace = "answerValues" + '"' + ":[";
            //        record.JSON_DATA = record.JSON_DATA.Replace(search, replace);

            //        BprResponses bprResponses = serializer.Deserialize<BprResponses>(record.JSON_DATA);
            //        if (bprResponses != null)
            //        {
            //            if (bprResponses.responseStatus != null)
            //            {
            //                if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireCompletedDate))
            //                {
            //                    bprResponses.responseStatus.questionnaireCompletedDate = string.Empty;
            //                    SaveBprResponses(userId, serializer.Serialize(bprResponses));

            //                    //Remove the PDF file
            //                    AHOBPRFileManager fileManager = new AHOBPRFileManager();
            //                    fileManager.DeleteFile(userId, AHOBPRGlobal.AhobprFileTypeResponsePdf);

            //                    //Remove the QuestionnaireCompletedDate from FORM_RESPONSE_STATUS table
            //                    AHOBPRFormResponseManager responseMananger = new AHOBPRFormResponseManager();
            //                    responseMananger.RemoveQuestionnaireCompleteDate(userId);
            //                }
            //            }
            //        }
            //    }
            //}

            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "responses/{userId}")]
        public string SaveBprResponses(string userId, string bprResponses)
        {
            throw new NotImplementedException();
            //string results = string.Empty;

            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //REGISTRANT_JSON registrantJson = manager.SaveJsonData(userId, AHOBPRGlobal.AhobprJsonDataTypeResponses, bprResponses, string.Empty);
            //if (registrantJson != null)
            //{
            //    try
            //    {
            //        results = registrantJson.JSON_DATA;
            //    }
            //    catch
            //    {
            //        results = string.Empty;
            //    }
            //}
            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "followupresponses/{userId}/{formId}")]
        public string SaveBprFollowupResponses(string userId, string formId, string bprResponses)
        {
            throw new NotImplementedException();
            //string results = string.Empty;
            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //REGISTRANT_JSON_FOLLOWUP registrantJson = manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeResponsesFollowup, formId, bprResponses, AHOBPRGlobal.AhobprJsonStatusCompleted, "no", string.Empty);
            //if (registrantJson != null)
            //{
            //    try
            //    {
            //        UpdateUserFollowupFormStatus(userId, formId);
            //        results = registrantJson.JSON_DATA;
            //    }
            //    catch
            //    {
            //        results = string.Empty;
            //    }
            //}

            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "form/{formId}")]
        public bool SaveBprForm(string formId, string bprForm)
        {
            throw new NotImplementedException();
            //bool results = false;

            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //REGISTRANT_JSON registrantJson = manager.SaveJsonData(formId, AHOBPRGlobal.AhobprJsonDataTypeForm, bprForm, string.Empty);
            //if (registrantJson != null)
            //{
            //    try
            //    {
            //        results = registrantJson.JSON_DATA.Length > 0;
            //    }
            //    catch
            //    {
            //        results = false;
            //    }
            //}
            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            UriTemplate = "upload/{fileType}/{fileId}")]
        public bool SaveFile(string fileType, string fileId, Stream pdfStream)
        {
            throw new NotImplementedException();
            //bool result = false;

            //AHOBPRFileManager manager = new AHOBPRFileManager();
            //result = manager.SaveFile(fileId, fileType, fileStream);

            //return result;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatevistalogin")]
        public bool UpdateVistaLogin(String userid)
        {
            throw new NotImplementedException();
            //return (new AHOBPRUserManager()).UpdateLastVistaLogin(userid);
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "dataaccesslog")]
        public bool SaveDataAccessLog(object dataAccessLog) //DataAccessLog dataAccessLog)
        {
            throw new NotImplementedException();
            //AHOBPRGenericManager manager = new AHOBPRGenericManager();
            //return manager.SaveDataAccessLog(dataAccessLog.userId, dataAccessLog.pageName, dataAccessLog.userAgent);
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "updatemessagestatus/{userId}")]
        public string UpdateMessageStatus(string userId, string bprMessages)
        {
            throw new NotImplementedException();
            //string results = string.Empty;
            //AHOBPRJsonDataManager manager = new AHOBPRJsonDataManager();
            //List<string> records = manager.GetJsonFollowups(userId, AHOBPRGlobal.AhobprJsonTypeMessage);
            //if (records.Count > 0)
            //{
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    BprMessage message = new BprMessage();
            //    List<BprMessage> messages = new List<BprMessage>();
            //    foreach (string jsonData in records)
            //    {
            //        message = serializer.Deserialize<BprMessage>(jsonData);
            //        if (message.status == AHOBPRGlobal.AhobprJsonStatusNew)
            //        {
            //            message.status = AHOBPRGlobal.AhobprJsonStatusCompleted;
            //            message.completedDate = DateTime.Now.ToString();
            //            string messageJson = serializer.Serialize(message);
            //            manager.SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeMessage, message._id, messageJson, AHOBPRGlobal.AhobprJsonStatusCompleted, "no", string.Empty);
            //        }
            //        messages.Add(message);
            //    }
            //    BprMessages newMessages = new BprMessages();
            //    newMessages.userId = userId;
            //    messages = (from m in messages
            //                orderby m._id descending
            //                select m).ToList();
            //    newMessages.messages = messages.ToArray();
            //    results = serializer.Serialize(newMessages);
            //}

            //return results;
        }

        [OperationContract]
        [WebInvoke(Method = "POST",
            ResponseFormat = WebMessageFormat.Json,
            BodyStyle = WebMessageBodyStyle.Wrapped,
            UriTemplate = "saveinterfacelog/{userId}")]
        public bool SaveInterfaceLog(string userId, string value)
        {
            throw new NotImplementedException();
            //AHOBPRGenericManager manager = new AHOBPRGenericManager();
            //return manager.SaveInterfaceLog(userId, value);
        }

        #endregion

        #region utils

        private bool EdipiIsValid(string edipi)
        {
            Regex regex = new Regex("^\\d{10}$", RegexOptions.Compiled);
            return !(string.IsNullOrEmpty(edipi) || !regex.IsMatch(edipi));
        }

        #endregion
    }
}